/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	ConstrainSeparationPointToLine.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT ConstrainSeparationPointToLine(IPoint *point1, ILine *line1)
{

//	Creates a PLLinearDim constraint between the given point and the given line

	START_METHOD("ConstrainSeparationPointToLine")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IPLLinearDim *plLinearDim = NULL;
	status = (GetCLASS(PLLinearDim))->CreatePLLinearDim(point1, line1, &plLinearDim);
	CHECK_RETURN_STATUS(status)

	IConstraint *pConstraint = NULL;

	status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint,plLinearDim), &pConstraint);
	CHECK_RETURN_STATUS(status)

	END_METHOD("ConstrainSeparationPointToLine")
}
